set sql_safe_updates=0;


-- Appliocant Reset Password for internal notification        
SET @applicantResetPassword=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_RESET_PASSWORD_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T5.`salutationName` AS SALUTATION_NAME,
    T4.`firstName` AS FIRST_NAME,
    T4.`middleName` AS MIDDLE_NAME,
    T4.`lastName` AS LAST_NAME,
    T4.`emailId` AS EMAIL_ID,
    T4.`mobileNumber` AS MOBILE_NO,
    T4.`mobileCountryCode` AS MOBILE_CODE,
    T4.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    ml.code as LANGUAGE_KEY,
    'APPLICANT' AS USER_TYPE_KEY
FROM
    `external_users` T1 
        INNER JOIN
	`external_user_association` T2 ON T2.`externalUserId` =T1.`id`
		LEFT JOIN
    `application` T3 ON T3.`id` = T2.`applicationId`
		LEFT JOIN
    `applicant_person` T4 ON T4.`id` = T3.`applicantPersonId`
        LEFT JOIN
    `salutations` T5 ON T5.`id` = T4.`salutationId`
        LEFT JOIN
	multi_language ml on ml.id=T4.correspondence_language
WHERE
    T1.id IN(namedParams)" WHERE `dataProviderId`=@applicantResetPassword;
    
    -- APPLICANT FORM SUBMIT
    
    SET @applicantFormSubmit=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_FORM_SUBMIT_RECIPIENTS');

	UPDATE `sql_dtprovider` SET `sqlQuery`="select T1.id AS ID,
		T2.`firstName` AS FIRST_NAME,
		T2.`middleName` AS MIDDLE_NAME,
		T2.`lastName` AS LAST_NAME,
		T2.`emailId` AS EMAIL_ID,
		T2.`mobileNumber` AS MOBILE_NO,
		T1.`code` as APPLICATION_CODE,
		T2.`mobileCountryCode` as MOBILE_CODE,
		T2.`alternateEmailId` as ALTERNATE_EMAIL_ID,
		 ml.`code` as LANGUAGE_KEY,
		'APPLICANT' AS USER_TYPE_KEY
	from application T1 
		left outer join applicant_person T2 on T1.applicantPersonId=T2.id
		left outer join
		external_user_association T5 on T5.applicationId = T1.id 
		left outer join
		external_users T4 on T4.id = T5.externalUserId 
		left outer join
		multi_language ml ON ml.id = T2.correspondence_language
		where T1.id in (namedParams)" WHERE `dataProviderId`=@applicantFormSubmit;
    
		
	SET @applicantSendOffer=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_APPLICANT_DTP');

	UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT
   T2.id AS ID,
   T3.`salutationName` AS SALUTATION_NAME,
   T2.`firstName` AS FIRST_NAME,
   T2.`middleName` AS MIDDLE_NAME,
   T2.`lastName` AS LAST_NAME,
   T2.`emailId` AS EMAIL_ID,
   T2.`mobileNumber` AS MOBILE_NO,
   T2.`mobileCountryCode` AS MOBILE_CODE,
   T5.`loginId` AS LOGIN_ID,
   CONVERT(FROM_BASE64(T5.passwordBase64) USING utf8) AS PASSWORD,
   CONCAT(T9.addressText,' ',T10.cityName,', ',T11.countryName,', ',T12.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
   DATE_FORMAT(T14.admissionOfferStartDate ,'%d-%m-%Y') as OFFER_LETTER_START_DATE,
   DATE_FORMAT(T14.admissionOfferEndDate ,'%d-%m-%Y') as OFFER_LETTER_END_DATE,
   'APPLICANT' AS USER_TYPE_KEY
FROM
   `application` T1 
		INNER JOIN
	`applicant_person` T2 ON T2.id = T1.applicantPersonId 
		LEFT JOIN
	`salutations` T3 ON T3.`id` = T2.`salutationId`
		LEFT JOIN
	`external_user_association` T4 ON T4.`applicationId` = T1.`id`
		LEFT JOIN
	`external_users` T5 ON T5.`id` = T4.`externalUserId`
    LEFT JOIN
    application_program T6 ON T6.applicationId = T1.id
		LEFT OUTER JOIN
    academy_location T7 ON T7.id = T6.academyLocationId
		LEFT OUTER JOIN
    academy_location_addresses T8 ON T8.academyLocationId = T7.id
		LEFT OUTER JOIN
    address T9 ON T9.id = T8.addressId && T9.addressTypeId=10
		LEFT OUTER JOIN
	city T10 ON T10.id = T9.cityId
		LEFT OUTER JOIN
	country T11 ON T11.id = T10.countryId
		LEFT OUTER JOIN
	country_region T12 ON T12.id = T10.countryRegionId
		LEFT JOIN
	program_selection_process T13 on T13.programBatchSeatConfigId = T6.progBatchSeatConfigId
		LEFT JOIN
	prog_slctn_process_admisn_conf T14 on T14.programSelectionProcessId = T13.id
WHERE
   T2.id IN 
   (
      namedParams
   )" WHERE `dataProviderId`=@applicantSendOffer;
   
   -- SEND PROVISIONAL OFFER LETTER
   	SET @applicantProvisionalOffer=(SELECT id FROM dtprovider WHERE `dataProviderName`='SEND_PROVISIONAL_OFFER_LETTER_INFO');

	UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT
   T2.id AS ID,
   T3.`salutationName` AS SALUTATION_NAME,
   T2.`firstName` AS FIRST_NAME,
   T2.`middleName` AS MIDDLE_NAME,
   T2.`lastName` AS LAST_NAME,
   T2.`emailId` AS EMAIL_ID,
   T2.`mobileNumber` AS MOBILE_NO,
   T2.`mobileCountryCode` AS MOBILE_CODE ,
   'APPLICANT' AS USER_TYPE_KEY
FROM
   `application` T1 
   INNER JOIN
      `applicant_person` T2 
      ON T2.id = T1.applicantPersonId 
   LEFT JOIN
      `salutations` T3 
      ON T3.`id` = T2.`salutationId` 
WHERE
   T2.id IN (namedParams)" WHERE `dataProviderId`=@applicantProvisionalOffer;
   
   -- APPROVE APPLICATION
   
   	SET @approveApplication=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPROVE_APPLICATION_RECIPIENTS');

	UPDATE `sql_dtprovider` SET `sqlQuery`="select T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T1.`code` as APPLICATION_CODE,
	ml.code as LANGUAGE_KEY,
    (CASE
        WHEN
            T5.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T5.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (Case 
        when 
            T5.footerUrl is not null 
                and org.orgUrl IS NOT NULL 
        then 
            CONCAT(org.orgUrl, '/', T5.footerUrl)
        else NULL 
    end) as FOOTER_URL ,
    'APPLICANT' AS USER_TYPE_KEY
    from application T1 
    left outer join applicant_person T2 on T1.applicantPersonId=T2.id
    left outer join salutations T3 on T3.id = T2.salutationId
    LEFT OUTER JOIN
    application_program T4 ON T4.applicationId = T1.id
        LEFT OUTER JOIN
    academy_location T5 ON T5.id = T4.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
	left outer join multi_language ml on ml.id=T2.correspondence_language
    where T1.id in(namedParams)" WHERE `dataProviderId`=@approveApplication;
    
    -- EXTERNAL USER FORGOT PASSWORD
    SET @externalUser=(SELECT id FROM dtprovider WHERE `dataProviderName`='EXTERNAL_USER_FORGOT_PASSWORD_RECEPIENT_INFO');

	UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T4.`firstName` AS FIRST_NAME,
    T4.`lastName` AS LAST_NAME,
    T4.`emailId` AS EMAIL_ID,
    T4.`mobileNumber` AS MOBILE_NO,
    T4.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    T4.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY,
    'APPLICANT' AS USER_TYPE_KEY
FROM
    external_users T1
        LEFT JOIN
    external_user_association T2 ON T2.externalUserId = T1.id
        LEFT JOIN
    application T3 ON T3.id = T2.applicationId
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
		LEFT JOIN
	multi_language ml on ml.id=T4.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@externalUser;
    
set sql_safe_updates=1;